/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)errexit.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */
/* -- ERROREXIT ------------------------------------------------------------- */
/*                                                                            */
/* Subroutine to print an error message and exit the program.                 */
/*                                                                            */
/* Errorexit selects the appropriate error message from the array             */
/* of error messages, adds the fitting name to the front of it,               */
/* trims the spaces, and sends it to perrlog.                                 */
/* If the string ends with '!' the program is aborted; otherwise errorexit    */
/* returns the error number of the message printed.                           */
/*                                                                            */
/* ENTRY REQUIREMENTS:                                                        */
/*	errnum:		an integer code for an error message in array "error" */
/*	NumErrors:	the total number of error messages                    */
/*	fitting:	the name of the program calling this routine          */
/*      error:		the array of error messages                           */
/*                                                                            */
/*	Development History:                                                  */
/*		Begun:	7/16/86 - Marco Zagha                                 */
/*                       Under GG44 support.                                  */
/*		Update:	8/4/86  - Marco Zagha (return/exit option added)      */
/*                       Under GG44 support.                                  */
/*		Update:	2/24/87 - Marco Zagha (new plog calls)                */
/*                       Under GG44 support.                                  */
/*		Update:	4/6/87 - Marco Zagha (exit for unknown error number)  */
/*                       Under GG44 support.                                  */
/*                                                                            */
/* -------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>

errorexit(errnum, NumErrors, fitting, error)
int errnum;
int NumErrors;
char fitting[];
char *error[];
{
int perrlog(), scaseup(), trimspc();
char *malloc();

char *tmp_str;
int last;

scaseup(fitting);
trimspc(fitting);
if (errnum >= 0 && errnum < NumErrors)
 {
  tmp_str = malloc((unsigned) (strlen(fitting) + strlen(error[errnum]) + 5));
  if (tmp_str == NULL) exit(-errnum-1);
  sprintf(tmp_str, "%s:  %s", fitting, error[errnum]); 
 }
else
 {
  tmp_str = malloc((unsigned) (strlen(fitting) + 40));
  if (tmp_str == NULL) exit(-errnum-1);
  sprintf(tmp_str, "%s:  Error number %d has occured!", fitting, errnum);
  errnum = 0;
 }
last = strlen(tmp_str);
if (last == 0 || tmp_str[last-1] == '!')
  { 
    plog(tmp_str, 'E'); /* error */
    exit(-errnum-1);  /* -1 to insure negative exit number */
  }
else
    plog(tmp_str, 'I'); /* information */
return(errnum);
}




/* -- INSERTFILLER ---------------------------------------------------------- */
/*                                                                            */
/* This function returns "message" with each occurence of '@' replaced by     */
/* filler.                                                                    */
/*                                                                            */
/* ENTRY REQUIREMENTS:                                                        */
/*	message:	a string containing '@'                               */
/*	filler:		the string which will replace '@'                     */
/*                                                                            */
/*	Development History:                                                  */
/*		Begun:	7/16/86 - Marco Zagha                                 */
/*                                                                            */
/* -------------------------------------------------------------------------- */
#include <string.h>

insertfiller(FilledMessage, message, filler)
char FilledMessage[];
char message[];
char filler[];

{
int  CurrentChar = 0;
int len;

strcpy(FilledMessage, "");

while (message[CurrentChar] != '\0')
  {
   if (message[CurrentChar] == '@')
      strcat(FilledMessage, filler);
   else 
     {
      len = strlen(FilledMessage);
      FilledMessage[len] = message[CurrentChar];
      FilledMessage[len + 1] = '\0';
     }
   CurrentChar++;
  }

return;
}


/* -- FILLERREXIT ----------------------------------------------------------- */
/*                                                                            */
/* Subroutine to print an error message with a filler and exit the program.   */
/*                                                                            */
/* Fillerrexit selects the appropriate error message from the array           */
/* of error messages, substitutes all occurences of '@' with the filler       */
/* (by calling insertfiller), adds the fitting name to the front of it,       */
/* trims the spaces, and sends it to perrlog.                                 */
/* If the string ends with '!' the program is aborted; otherwise errorexit    */
/* returns the error number of the message printed.                           */
/*                                                                            */
/* ENTRY REQUIREMENTS:                                                        */
/*	errnum:		an integer code for an error message in array "error" */
/*	NumErrors:	the total number of error messages                    */
/*	fitting:	the name of the program calling this routine          */
/*      error:		the array of error messages                           */
/*      filler:		the string to replace '@' in the error message        */
/*                                                                            */
/*	Development History:                                                  */
/*		Begun:	7/16/86 - Marco Zagha                                 */
/*		Update:	8/4/86  - Marco Zagha (return/exit option added)      */
/*		Update:	2/24/87 - Marco Zagha (new plog calls)                */
/*		Update:	4/6/87 - Marco Zagha (exit for unknown error number)  */
/*                                                                            */
/* -------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>

fillerrexit(errnum, NumErrors, fitting, error, filler)
int errnum;
int NumErrors;
char fitting[];
char *error[];
char filler[];

{
int perrlog(), scaseup(), trimspc();
char *malloc();

char *tmp_str;
char *FilledMessage;
int last;

scaseup(fitting);
trimspc(fitting);
if (errnum >= 0 && errnum < NumErrors)
 {
  FilledMessage = malloc((unsigned) (strlen(error[errnum])+strlen(filler)+5));
  if (FilledMessage == NULL) exit(-errnum-1);
  insertfiller(FilledMessage, error[errnum], filler);
  tmp_str = malloc((unsigned) (strlen(fitting)+strlen(FilledMessage)+5));
  if (tmp_str == NULL) exit(-errnum-1);
  sprintf(tmp_str, "%s:  %s", fitting, FilledMessage);
 } 
else
 {
  tmp_str = malloc((unsigned) (strlen(fitting) + 40));
  if (tmp_str == NULL) exit(-errnum-1);
  sprintf(tmp_str, "%s:  Error number %d has occured!", fitting, errnum);
 }

last = strlen(tmp_str);
if (last == 0 || tmp_str[last-1] == '!')
  { 
    plog(tmp_str, 'E'); /* error */
    exit(-errnum-1);  /* -1 to insure negative exit number */
  }
else
    plog(tmp_str, 'I'); /* information */
return(errnum);
}
