/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)ignoreinput.c	1.5  (UCLA, IGPP) 20 Apr 1994 
 */

/* -- IGNOREINPUT ------------------------------------------ */
/* Reads the data pipe without processing                    */
/* the input.  This routine should be called by all fittings */
/* which do not read input from the previous fittings.       */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   NONE                                                    */
/*                                                           */
/* RETURN VALUES:                                            */
/*   Always 1.                                               */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  4/23/87 - Marco Zagha                */
/*                  Under GG44 support.                      */
/*              Update: 6/8/87  - Marco Zagha                */
/*                              (no descriptor pipe anymore) */ 
/*                  Under GG44 support.                      */
/*              Update: 01/26/94 - Gilbert Hyatt             */
/*                  Changed Global Rbuffer to local variable */
/*              Edited:04/14/94 - Gilbert Hyatt              */
/*                Now uses pipec.h as entry point            */
/*                into the library.                          */
/* --------------------------------------------------------- */
ignoreinput()
{
#include "pipec.h"

#define EBSIZE 2048 

  char EndBuffer[EBSIZE];

  while (pread(datain, EndBuffer, EBSIZE) > 0)
   ; /* read descriptors until EOF or error */
  return(1);
}

