/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)stdpipec.h	1.2    (UCLA/IGPP)     16 Mar 1994
*/
/*------------------------------------------------------------*/
/* Definition of decriptors for the the auxillary pipes       */
/* Starting point of file descriptor 11 is because under VMS  */
/* any pre-opened file descriptor less than 11 is not passed  */
/* to the child. Making the standard numbers on both systems  */
/* has very little impact on the actual workings of the       */
/* system.                                                    */
/* Modified: 6/8/87 - Marco Zagha (descriptor pipes removed)  */
/* Modified: 10/2/87 - Todd King                              */
/*                          bump descriptors to start         */
/*                          at 11. (imposed by VMS)           */
/*------------------------------------------------------------*/

#ifndef STDPIPE
#define STDPIPE

#define EOLIST	-1		/* End of list marker */
#ifdef VMS
#define NORMAL	1		/* Exit code for normal termination */
#else		/* UNIX */
#define NORMAL	0		/* Exit code for normal termination */
#endif

#include "maxpipec.h"
#include <stdio.h>

#define initdfs(a)	_initdfs(&argc, argv, a)

int Datain[MAX_CONDUITS];
int Dataout[MAX_CONDUITS];
int Msglog;
FILE *Msglog_f;

#ifndef _DFS_FD_
extern  int datain;
extern  int dataout;
extern  int errlog;
#endif /* _DFS_FD_ */

#endif /* STDPIPE */
