/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%    (UCLA/IGPP)     %G%
*/
/*-----------------------------------------------------------
   Definitions used by the time routines.

   Development History:
      Begun: 3/28/90 - Todd King
---------------------------------------------------------------*/

#ifndef _CTIME_
#define _CTIME_	1

#include <stdio.h>
#include <time.h>

#define  AMERDATE    0      /* 1/19/83 11:45:30.234 */
#define  EURODATE    1      /* 19.1.83 11:45:30.234 */
#define  ABBRAMER    2      /* jan 19, 1983 11:45:30.234 */
#define  ABBREURO    3      /* 19 jan 1983 11:45:30.234 */
#define  LONGAMER    4      /* january 19, 1983 11:45:30.234 */
#define  LONGEURO    5      /* 19 january 1983 11:45:30.234 */
#define  NUMERICAL   6      /* 83.019 11:45:30.234 */
#define  DAYNUMBER   7      /* 303 11:45:30.234 */
#define  JAPANDATE   8      /* 83.1.19 11:45:30.234 */
#define  NIPPONDATE  9      /* 83.19.1 11:45:30.234 */
#define  HIGHLOW    10      /* 83 01 19 00 11 45 30.234 */
#define  ISEEDATE   11      /* 83 019 JAN 19 11 45 30.234 */
#define  DFS_STYLE  12      /* 1989-JAN-19 11:45:30.234 */
#define  ABBRDFS_STYLE 13   /* 1989/01/19 11:45:30.234 */
#define  PDS_STYLE  14      /* U19890119T11:45:30.234 */
#define  ISO        15      /* U19890119T114530.234 */
#define  BINARY     16      /* 758979930.234 */
#define  GLL_SCLK   17      /* 1120789:08:7:4 */

static char *Time_long_month_name[] = { "January", "February", "March",
      "April", "May", "June", "July", "August", "September",
      "October", "November", "December", "" };
static char *Time_month_list[] = { "JANUARY", "FEBRUARY", "MARCH",
      "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER",
      "OCTOBER", "NOVEMBER", "DECEMBER", "" };
static char *Time_short_month_name[] = { "Jan", "Feb", "Mar", 
      "Apr", "May", "Jun", "Jul", "Aug", "Sep", 
      "Oct", "Nov", "Dec", ""};
static char *Time_paradigms[] = { "AMERDATE", "EURODATE", "ABBRAMER",
      "ABBREURO", "LONGAMER", "LONGEURO", "NUMERICAL", "DAYNUMBER",
      "JAPANDATE", "NIPPONDATE", "HIGHLOW", "ISEEDATE", "DFS_STYLE",
      "ABBRDFS_STYLE", "PDS_STYLE", "ISO", "BINARY", "GLL_SCLK", "" };
static char *Time_token_kw[] = { "%year%", "%month%", "%day%",
      "%doy%", "%hour%", "%min%", "%sec%", "%msec%", NULL };

#define FMT_YEAR	0
#define FMT_MONTH	1
#define FMT_DAY		2
#define FMT_DOY		3
#define FMT_HOUR	4
#define FMT_MIN		5
#define FMT_SEC		6
#define FMT_MSEC	7

static int daymon[12] = {31,28,31,30,31,30,31,31,30,31,30,31};

#define REFYR	1966
#define TIME_MAX_STR	80
#define TIME_MAX_FORMAT_STR	512
#define TIME_MAX_TOKENS	15

typedef struct {
  char fmt_spec[TIME_MAX_FORMAT_STR + 1];
  int tokens[TIME_MAX_TOKENS];
  int ntokens;
} TIME_TOKEN;

char *make_time_str();
char *make_arb_time_str();
double parse_time();
double parse_time_str();
double parse_arb_time_str();
double sectime();
double secperyr();
double localcline();
struct tm *clinetm();

#endif /* _CTIME_ */
