/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)dataend.c	1.5  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- DATAEND -------------------------------------*/
/* Sends any remaining data in the output record  */
/* block out the data pipe. The closes the data   */
/* pipe by sending and End Of File down the pipe. */
/*                                                */
/*  Entry Requirements:                           */
/*    NONE                                        */
/*                                                */
/*  Developement History:                         */
/*    Begun: 11/4/86  - Todd King                 */
/*        Under GH06 support.                     */
/*    Update: 6/17/87 - Marco Zagha               */
/*        dataout used instead of Dataout         */
/*        Under GG44 support.                     */
/*    Update: 7/21/88 - Todd King                 */
/*        Checks if anything in output block.     */
/*        Under GH06 support.                     */
/*  Edited:04/14/94 - Gilbert Hyatt               */
/*    Now uses pipec.h as entry point             */
/*    into the library.                           */
/*------------------------------------------------*/
#include "pipec.h"

dataend()
{
  extern int Buffstarted;
  extern char Buffname[];
  extern BLOCK Out;

  if (Buffstarted) unlink(Buffname); /* Kill buffer file if opened */
  if(Out.guage > 0)
    write(dataout, Out.block, Out.guage); /* Send any remaining block */
  return(peof(dataout));
}
