/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)save_buff.c	1.4  (UCLA, IGPP) 20 Apr 1994 
*/
#include "pipec.h"

extern char *Rbuffer;	/* DFS working record */

/*-- dfs_save_buffer_record ------------------------------------
   Takes the contents of the current working record and stores
   it at the current record in the record buffer.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History
      Begun: 10/19/90 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
---------------------------------------------------------------*/
int
dfs_save_buffer_record(buffer)
DFS_RECBUFF *buffer;
{
   char *ptr;

   if(buffer == NULL) return(FALSE);

   ptr = buffer->raw + (buffer->cur_rec * buffer->recl);
   memcpy(ptr, Rbuffer, buffer->recl);

   return(TRUE);
}

