/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)setbuff.c	1.2  (UCLA, IGPP) 20 Apr 1994 
 */

/* -- SETBUFF ---------------------------------------------- */
/* Sets the number of records to buffer to disk and          */
/* initializes the buffer file.                              */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*	NUMRECS:  the number of records to buffer to disk.   */
/*                                                           */
/* RETURN VALUES:                                            */
/*	1 for valid buffer size.                             */
/*	-1 for invalid buffer size or error opening file.    */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  8/30/86 - Marco Zagha                */
/*                  Under GG44 support.                      */
/* --------------------------------------------------------- */
#include <stdio.h>

setbuff(numrecs)
int	numrecs;
{
  extern FILE *Buffptr;
  extern int Buffdesc;
  extern int Buffsize;
  extern int Buffstarted;
  extern char Buffname[];
  char tempstr[15];

  /* Can only set buffer once. */
  if ((Buffstarted == 1) || (numrecs <= 0)) return (-1);

  sprintf(tempstr, "%d", getpid() );
  strcpy(Buffname, "BU");
  strcat(Buffname, tempstr);
  if ((Buffptr = fopen(Buffname, "w+")) == NULL) return (-1);
  Buffdesc = fileno(Buffptr);
  Buffstarted = 1;
  Buffsize = numrecs;  
  return (1);
}

