/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)setdesc.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- SETDESC ----------------------------*/
/* Sets the fields of a descriptor in    */
/* the data base at the specifed         */
/* location to the given values. A       */
/* descriptor's type or width can not be */
/* set with this call.                   */
/* Returns zero if all goes well, -1     */
/* otherwise. Indexing starts at 1.      */
/*                                       */
/* Entry Requirements:                   */
/*    AT: The index at which to place    */
/*        this decription.               */
/*  LONGC: The long column name to use.  */
/* SHORTC: The short column name to use. */
/*  UNITS: The units label to use.       */
/*   SORT: The sort order of the column. */
/*                                       */
/* Development History:                  */
/*   Begun: 3/14/86 - Todd King          */
/*            Under GH06 support.        */
/*   Edited:04/14/94 - Gilbert Hyatt     */
/*     Now uses pipec.h as entry point   */
/*     into the library.                 */
/*---------------------------------------*/
setdesc(at,longc,shortc,units,sort)
int at,sort;
char longc[],shortc[],units[];
{
#include "pipec.h"

   int i,end;

   extern DESC Desc[];
   extern int Ndesc,Next_start;

   /* Store information, padding or truncating as neccessary */

   if(at > Ndesc || at < 1) return(-1);  /* No can do */
   at--;			/* Adjust to zero referencing */
   end=strlen(longc);
   if(end>32) end=32;
   for(i=0;i<end;i++) Desc[at].longcol[i]=longc[i];
   for(i=end;i<32;i++) Desc[at].longcol[i]=' ';
   Desc[at].longcol[32]='\0';
   end=strlen(shortc);
   if(end>8) end=8;
   for(i=0;i<end;i++) Desc[at].shortcol[i]=shortc[i];
   for(i=end;i<8;i++) Desc[at].shortcol[i]=' ';
   Desc[at].shortcol[8]='\0';
   end=strlen(units);
   if(end>16) end=16;
   for(i=0;i<end;i++) Desc[at].units[i]=units[i];
   for(i=end;i<16;i++) Desc[at].units[i]=' ';
   Desc[at].units[16]='\0';
   Desc[at].sort=sort;
   return(0);
}

