/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-----------------------------------------------------------------
  Include file for binary format conversion functions.

  Development History:
    Begun: XX/XX/XX - Todd King
    Modified: 8/24/93 - Kirk Ketefian

  Version:
       @(#)BC.h	1.7      (UCLA/IGPP)     1/27/94
-----------------------------------------------------------------*/
#ifndef bc_h
#define bc_h 1

#include <stdio.h>      /* For NULL */
 
#define BCSuccess	1
#define BCFailure	0

static enum { BCFormatNULL = 0, BCFormatSun, BCFormatHP1000, 
              BCFormatIBM370, BCFormatMSB, BCFormatPC, BCFormatVAX
            };
static char *BCFormatList[] = { "NULL", "SUN", "HP1000",
                                "IBM370", "MSB", "PC", "VAX",
                                NULL
                              };

/* Define generic types */
#ifdef _MSDOS
typedef long int	int4;
typedef unsigned long	unsigned_int4;
#else
typedef int			int4;             
typedef unsigned int	unsigned_int4;
#endif

typedef  unsigned_int4 BCBinary; 

typedef union {
   struct {
#ifdef vax
      BCBinary mantissa0 : 16;
      BCBinary mantissa1 : 7;
      BCBinary exponent : 8;
      BCBinary sign : 1;
#else
      BCBinary sign : 1;
      BCBinary exponent : 8;
      BCBinary mantissa1 : 7;
      BCBinary mantissa0 : 16;
#endif
   } field;
   float val;
} BCIEEEFloat;

typedef union {
   struct {
#ifdef vax
      BCBinary mantissa0 : 16;
      BCBinary mantissa1 : 16;
      BCBinary mantissa2 : 16;
      BCBinary mantissa3 :  4;
      BCBinary exponent  : 11;
      BCBinary sign      :  1;
#else
      BCBinary sign : 1;
      BCBinary exponent : 11;
      BCBinary mantissa3 : 4;
      BCBinary mantissa2 : 16;
      BCBinary mantissa1 : 16;
      BCBinary mantissa0 : 16;
#endif
   } field;
   double val;
} BCIEEEDouble;

/* Prototypes for functions */

BCBinary BCMakeMask();
BCBinary BCCompliment();
BCBinary BCExtractBits(); 
void BCSwapBytes();
void BCSwap2BWord();
void BCSwap4BWord();

/* Function pointers */

void (*BCFloatToIEEE)();
void (*BCIEEEToFloat)();

void (*BCDoubleToIEEE)();
void (*BCIEEEToDouble)();

void (*BCGFloatToIEEE)();
void (*BCIEEEToGFloat)();

void (*BCShortToIEEE)();
void (*BCIEEEToShort)();

void (*BCIntegerToIEEE)();
void (*BCIEEEToInteger)();

void (*BCLongIntegerToIEEE)();
void (*BCIEEEToLongInteger)();

void (*BCCharToASCII)();
void (*BCASCIIToChar)();

void (*BCReverseByteOrder)();

/* General purpose function prototypes */

void BCGenericReverseByteOrder();
void BCDoNothing();
                    
int BCIsIEEEFloatNaN();
int BCSetIEEEFloatNaN();
int BCIsIEEEDoubleNaN();
int BCSetIEEEDoubleNaN();

void BCNullFormat();
void BCSunFormat();
void BCMSBFormat();
void BCHP1000Format();
void BCVAXFormat();
void BCPCFormat();
void BCIBM370Format();

#endif /* bc_h */
