/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- FIND_REP2 --------------------------------------*/
/* Function to find and replace all occurances       */
/* a given substring with another string in a source */
/* string.                                           */
/* Returns the number of replacements made           */
/*                                                   */
/* On Entry:                                         */
/*  IN: The string to search for the word to replace */
/* FIND: The string to find in IN.                   */
/*  REP: The string to replace FIND with.            */
/*                                                   */
/* NOTE: A buffer area must be declared which will   */
/*       hold all temporary strings. This buffer must*/
/*       be large enough to accomodate               */
/*	 a string as long as the sum of the width and*/
/*       margin. The name of this buffer MUST be:    */
/*                                                   */
/*            Tmpbuffer                              */
/*                                                   */
/* Development History:                              */
/*   Begun: 8/31/85 - Todd King                      */
/*           Under GY49 support                      */
/* Revision: 11/19/86 - Marco Zagha (From findrep -  */
/*                The IN parameter now not changed.) */
/*           Under GG44 support                      */
/*                                                   */
/*  Version:                                         */
/*     @(#)findrep2.c	1.2      (UCLA/IGPP)     24 Sep 1993                  */
/*---------------------------------------------------*/
#include <string.h>
int findstr();

extern char Tmpbuffer[];	/* Declared in findrep.c */

findrep2(in,find,rep)
char in[],find[],rep[];
{
  int ret,n,cnt;
  char *ptr;

  n=0;
  ptr=(&in[n]);
  strcpy(Tmpbuffer,"");

  while((ret=findstr(find,ptr,'"')) != -1)
  {
    ptr[ret]='\0';
    strcat(Tmpbuffer,ptr);
    strcat(Tmpbuffer,rep);
    n=ret+strlen(find);
    ptr=(&ptr[n]);
    cnt++;
  }
  if(cnt > 0)  /* Finish up - replacements made */
  {
    strcat(Tmpbuffer,ptr);
  }
  return(cnt);
}

