/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- PACKLIST -----------------------------------------------------*/
/* Packs a list of character strings so that there are no strings  */
/* of zero length in the list. (except for at the end).            */
/*                                                                 */
/*  Entry Requirements:                                            */
/*     part: the array of character pointers which point to the    */
/*           list of strings.                                      */
/*     npart: the number of parts in the list.                     */
/*                                                                 */
/*  Returns:                                                       */
/*    The actual number of valid parts in the list                 */
/*                                                                 */
/*  Development History:                                           */
/*    Begun: 02/19/87 - Todd King                                  */
/*          Under GG44 support.                                    */
/*                                                                 */
/*  Version:                                                       */
/*     @(#)packlist.c	1.1      (UCLA/IGPP)     03 Mar 1992                                */
/*-----------------------------------------------------------------*/
#include <string.h>  /* For strlen() */

packlist(part, npart)
char *part[];
int npart;
{
  int i, j, at, last;
  unsigned int go;

  go=1;
  at=0;
  while(go)
  {
    while(at < npart && strlen(part[at]) > 0 ) at++;
    if (at >= npart) {go = 0; continue;}
    i=0;
    while((at+i) < npart && strlen(part[at+i]) == 0 ) i++;
    last = npart - at - i;
    for(j=0; j<last; j++) part[at+j] = part[at+i+j]; 
    npart-=i;
    at++;
  }
  return(npart);
}
