
/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)pflush.c	1.2  (UCLA, IGPP) 20 Apr 1994
 */
/*-- PFLUSH -------------------------------------------------------
  Flushes all the data pending for a actual write by performing the
  write. This clears just the output buffer. The input buffer is left
  as is.

   Returns:
     Always 1.

   Entry Requirements:
      NONE.

    Developement History:
      Begun: 09/18/88 - Todd King
                    Under GH06 support.
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
-------------------------------------------------------------------*/
#include "pipec.h"

pflush()
{
  extern BLOCK Out;
  extern BLOCK In;

  if(Out.guage > 0)	/* Something in output buffer */
  {
    write(dataout, Out.block, Out.guage);
    Out.guage = 0;
  }
  return(1);
}
