/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)in_dir.c	1.1   (UCLA/IGPP)   11 Dec 1992
 */

/* -- IN-DIRECTORY ----------------------------------------- */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*    FILE_NAME:  Name of the file to check.                 */
/*    DIR_NAME:   Name of a directory.                       */
/*                                                           */
/* RETURN VALUES:                                            */
/*    1 if FILE_NAME is in DIR_NAME; 0 otherwise.            */
/*                                                           */
/* NOTE:                                                     */
/*    1) if DIR_NAME = "" the current directory is used.     */
/*    2) if FILE_NAME is a subdirectory of DIR_NAME, 1       */
/*       is returned.                                        */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  11/8/86 - Marco Zagha                */
/*                   Under GG44 support                      */
/* --------------------------------------------------------- */
#include <stdio.h>
#include <string.h>

int trimspc();	/* In parserc */

in_directory(file_name, dir_name)
char	 file_name[];
char	 dir_name[];
{
  int	 dir_length;
  char	 temp_dir[100];
  char	 temp_file[100];
  FILE	*file_ptr;

/* Concatenate file_name to the end of dir_name adding a "/"
 * if necessary.
 */
  strcpy(temp_file, file_name);
  strcpy(temp_dir, dir_name);
  trimspc(temp_dir);
  trimspc(temp_file);
  dir_length = strlen(temp_dir);
  if ((dir_length != 0) && (temp_dir[dir_length - 1] != '/'))
    strcat(temp_dir, "/");
  strcat(temp_dir, temp_file);

/* Check existence by attempting to open */

  file_ptr = fopen(temp_dir, "r");
  if (file_ptr == NULL)
    return (0);
  else
    {
      fclose(file_ptr);
      return(1);
    }
}
