/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- DO_JUSTIFY --------------------------------------*/
/* Justifies text in a string according to the format */
/* instructions that follow:                          */
/*                                                    */
/*   $R  : Right justify                              */
/*   $C  : Center justify                             */
/*   $L  : Left justify                               */
/*                                                    */
/* On entry:					      */
/*  STRING: The string to perform formatting on. The  */
/*          format specifications being embedded in   */
/*          the string.                               */
/*  MARGIN: The number of spaces in the left margin.  */
/*  WIDTH:  The maximum width the string is to have.  */
/*                                                    */
/* Returns:                                           */
/*  the length of the resulting string.               */
/*                                                    */
/* NOTE: A buffer area must be declared which will    */
/*       hold all temporary strings. This buffer must */
/*       be large enough to accomodate                */
/*	 a string as long as the sum of the width and */
/*       margin. The name of this buffer MUST be:     */
/*                                                    */
/*            Tmpbuffer                               */
/*                                                    */
/*  History:                                          */
/*   Begun: 8/1/86 - Todd King                        */
/*          Under GG44 support.                       */
/*                                                    */
/*  Version:                                          */
/*     @(#)dojusty.c	1.2      (UCLA/IGPP)     24 Sep 1993                   */
/*----------------------------------------------------*/
#include <string.h> /* For str...() */
int findstr();

extern char	Tmpbuffer[];	/* Declared in findrep.c */

dojustify(string,margin,width)
char string[];
{
  int len, i, temp, last, next;
  char *ptr;
  int where_r, where_c, where_l;
  char *center="$C";
  char *left="$L";
  char *right="$R";

  where_c=findstr(center,string,'"');
  where_r=findstr(right,string,'"');
  where_l=findstr(left,string,'"');

  len=strlen(string);
  strcpy(Tmpbuffer,"");	/* truncate string */
  for(i=0;i<margin;i++) strcat(Tmpbuffer," ");  /* Add in margin */

  if(where_c == -1 && where_r == -1 && where_l == -1)  /* Nothing special */
  {
    strcat(Tmpbuffer,string);	/* Move in string */
    strcpy(string,Tmpbuffer);	/* replace string with new version */
    len=strlen(string);		/* Determine length */
    return(len);
  }

  if(where_l != -1)	/* Left justified text specified */
  {
    next=where_l;
    if(where_r > where_l) next=where_r;
    if(where_c > where_l && where_c < next) next=where_c;
    if(next > where_l) last=next;
    else last=len;
    ptr=(&string[where_l+2]);
    strncat(Tmpbuffer,ptr,last-(where_l+2));
  }

  if(where_c != -1)	/* Centered text specified */
  {
    next=where_c;
    if(where_l > where_c) next=where_l;
    if(where_r > where_c && where_r < next) next=where_r;
    if(next > where_c) last=next;
    else last=len;
    temp=(width-(last-(where_c+2)))/2;  /* Number of spaces to pad to center */
    if(temp > (int) strlen(Tmpbuffer))  /* Add spaces if needed */
    {
      for(i=strlen(Tmpbuffer);i<temp;i++) strcat(Tmpbuffer," ");
    }
    else	/* Truncate at start of centered text */
    {
      Tmpbuffer[temp]='\0';
    }
    ptr=(&string[where_c+2]);
    strncat(Tmpbuffer,ptr,last-(where_c+2));
  }

  if(where_r != -1)	/* Right justified text specified */
  {
    next=where_r;
    if(where_l > where_r) next=where_l;
    if(where_c > where_r && where_c < next) next=where_c;
    if(next > where_r) last=next;
    else last=len;
    temp=width-(last-(where_r+2));  /* Number of spaces to to right justifiy */
    if(temp > (int) strlen(Tmpbuffer))  /* Add spaces if needed */
    {
      for(i=strlen(Tmpbuffer);i<temp;i++) strcat(Tmpbuffer," ");
    }
    else	/* Truncate at start of centered text */
    {
      Tmpbuffer[temp]='\0';
    }
    ptr=(&string[where_r+2]);
    strncat(Tmpbuffer,ptr,last-(where_r+2));
  }
  strcpy(string,Tmpbuffer);	/* Replace with formatted string */
  len=strlen(string);
  return(len);
}

