/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
#include <ctype.h>

/*-- NEXT_WORD ---------------------------------------*/
/* Returns the next word from the given string.       */
/*                                                    */
/* On ENTRY:                                          */
/*  STRING: The string to retrieve the next word from */
/*  WORD  : The next word, null if no word available  */
/*  DELIM : Whatever it is that deliminates the end   */
/*          of the word.                              */
/*                                                    */
/* Return Value:                                      */
/*   The number of characters in the next word.       */
/*   -1 if end of line.                               */
/*                                                    */
/*  Development History:                              */
/*   Begun: 8/8/86 - Todd King                        */
/*        Under GH06 support.                         */
/*   Revised: 2/19/87 - Marco Zagha                   */
/*        Under GG44 support.                         */
/*   Revised: 7/28/88 - Marco Zagha                   */
/*      Misplaced parenthesis in while loop.          */
/*        Under GY49 support.                         */
/*                                                    */
/*  Version:                                          */
/*     @(#)nextword.c	1.1      (UCLA/IGPP)     03 Mar 1992                   */
/*----------------------------------------------------*/
nextword(string,word,delim)
char string[], word[], delim[];
{
  int i,j;

/*-- Extract word --*/

  i=0;
  if(string[i]=='\0') return(-1);
  while(isalpha(string[i]) || isdigit(string[i]))
  {
    word[i]=string[i];
    i++;
  }
  word[i]='\0';

/*-- Extract delimnator - if one exits --*/

  j=0;
  delim[j]='\0';
  if(string[i] =='\0') return(i);
  while(!(isalpha(string[i+j]) || isdigit(string[i+j]) || (string[i+j]=='\0')))
  {
    delim[j]=string[i+j];
    j++;
  }
  delim[j]='\0';
  return(i);
}
   
