/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- PARSE --------------------------------*/
/* Parses a source string into substrings  */
/* defined by the given deliminator. The   */
/* pointer array is filled with indexes to */
/* the start of each substring             */
/* A quote (") in the string is a parse    */
/* toggle. Turning off the search for the  */
/* delimanting string when first           */
/* encountered, then on when encountered   */
/* again. Two consequetive quotes are      */
/* translated into a single quote without  */
/* toggling the search for the deliminator */
/*                                         */
/* Entry Requirements:                     */
/*   STRING:  The string to parse.         */
/*   PTR_ARRAY: The array which will       */
/*             'contain' each part parsed  */
/*             from STRING.                */
/*   DELIM: The deliminator between parts  */
/*   MAX: The maximum number of parts to   */
/*        break STRING into.               */
/*                                         */
/* NOTE: calls the function FINDSTR, which */
/* returns the location of a given sub-    */
/* string in another given string.         */
/* Returns the number of parameters found. */
/*                                         */
/* Development History:                    */
/*  Begun: 11/21/85 - Todd King            */
/*             Under GH06 support.         */
/*                                         */
/*  Version:                               */
/*     @(#)parse.c	1.1      (UCLA/IGPP)     03 Mar 1992        */
/*-----------------------------------------*/ 
#include <string.h>	/* For strlen() */
int findstr();

parse(string,ptr_array,delim,max)
char string[],*ptr_array[],delim[];
int max;
{
int n,ret;
int start;
 
    if(strlen(string) == 0) return(0); /* nothing to parse */
    start=0;
    n=0;
    max--;	/* Needed  becuase of zero indexing */
    ptr_array[n]=(&string[start]);
    while((ret=findstr(delim,ptr_array[n],'"')) != -1 && n < max)
    { 
       n++;
       start+=ret;
       string[start]='\0';
       start+=strlen(delim);
       ptr_array[n]=(&string[start]);
    }
    return(++n);  /* return number of parameters */
}

