/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/* -- TRUNCATE_STR ----------------------------------------- */
/* Truncates a string to the given length.                   */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   STR: the string to truncate.                            */
/*   N:   number of characters to truncate to.               */
/*                                                           */
/* RETURN VALUES:                                            */
/*   1 if any truncation done; 0 otherwise.                  */
/*                                                           */
/* Development History:                                      */
/*     Begun:  3/30/87 - Marco Zagha                         */
/*         Under GG44 support                                */
/*                                                           */
/*  Version:                                                 */
/*     @(#)truncstr.c	1.1      (UCLA/IGPP)     03 Mar 1992                          */
/* --------------------------------------------------------- */
#include <string.h>	/* For strlen() */

truncate_str(str, n)
char str[];
int n;
{
  if (n < 0) return (-1);
  if ((int) strlen(str) > n)
   {
    str[n] = '\0';
    return (1);
   }
  else 
    return (0);
}
