/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      @(#)BufDeleteRecs.c	1.2  (UCLA, IGPP) 20 Apr 1994 
*/
/*-------------------------- ------------------------------------
  BufDeleteRecs(int start, int end)-
    Deletes a group of record, start at start to end form the 
    buffer list.

  Return:
    TRUR it all went well, else FALSE.

  Entry Requirements:
    int start
    int end
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
 
  ---------------------------------------------------------------*/ 
#include "pipec.h"

int 
BufDeleteRecs(start, end)
int start;
int end;
{
  int index, the_start, the_end;
  int test = 1;

  extern BUFFER_HEAD  _Rbuffer;

  if (start > end) return(FALSE);
  the_start = (start < 1)            ?1             :start;
  the_end   = (end  > _Rbuffer.nrecs)?_Rbuffer.nrecs:end;

  for (index = the_start; index <= the_end; index++)
    test = (BufDeleteRec(start) && test);
  
  return(test);
}  /* end of BufDeleteRec2() */
