/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)getbpline.c	1.4  (UCLA, IGPP) 20 Apr 1994 
 */

/* -- GETBPLINE -------------------------------------------- */
/* Gets the blue print file line number of the fitting from  */
/* the command line options.                                 */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   ARGC, ARGV                                              */
/*                                                           */
/* RETURN VALUES:                                            */
/*   1 if the line number is found; 0 otherwise              */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  2/13/87 - Marco Zagha                */
/*                  Under GG44 support.                      */
/*              Edited: 03/29/94 - Gilbert Hyatt             */
/*              Edited: 04/14/94 - Gilbert Hyatt             */
/*                Now uses pipec.h as entry point            */
/*                into the library.                          */
/* --------------------------------------------------------- */
getbpline(argc, argv)
int argc;
char *argv[];
{
#include "pipec.h"

  char tempstr[100];
  char *parts[2];

  if(argv[argc-1] == NULL) return(0);                /* prevent core dump */
  strncpy(tempstr, argv[argc-1], sizeof(tempstr)-1); /* prevent core dump */
  parse(tempstr, parts, "=", 2);
  if (!strcmp(parts[0], "_BP_LINE"))
   {
    pdbFittingID = atoi(parts[1]); 
    return(1);
   }
  else return(0);
}
